/*
 * Decompiled with CFR 0.152.
 */
package tools.mlocale;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import tools.mlocale.LanguageResolver;
import tools.mlocale.Preferences;

public class MobileLocalizationTool
extends JFrame {
    private static final long serialVersionUID = 1L;
    private File sourceFile;
    private File targetDirectory;

    public MobileLocalizationTool() {
        super("Mobile Localization");
        final JTextField sourceFileField = new JTextField();
        final JTextField targetDirectoryField = new JTextField();
        JButton browseSource = new JButton("Browse");
        JButton browseTarget = new JButton("Browse");
        Dimension d = sourceFileField.getPreferredSize();
        d.width = 400;
        sourceFileField.setPreferredSize(d);
        d = targetDirectoryField.getPreferredSize();
        d.width = 400;
        targetDirectoryField.setPreferredSize(d);
        browseSource.addActionListener(new BrowseFilesButtonActionListener(sourceFileField, new FileFilter(){

            @Override
            public String getDescription() {
                return "Excel";
            }

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String name = f.getName().toLowerCase();
                return name.endsWith(".xls") || name.endsWith(".xlsx");
            }
        }));
        browseTarget.addActionListener(new BrowseDirectoriesButtonActionListener(targetDirectoryField));
        sourceFileField.getDocument().addDocumentListener(new DocumentListener(){

            public void updateSourceFile() {
                MobileLocalizationTool.this.sourceFile = MobileLocalizationTool.this.parseFile(sourceFileField.getText());
                Preferences p = Preferences.getInstance();
                p.setSourceFile(MobileLocalizationTool.this.sourceFile != null ? MobileLocalizationTool.this.sourceFile.getAbsolutePath() : "");
                p.save();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateSourceFile();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateSourceFile();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateSourceFile();
            }
        });
        targetDirectoryField.getDocument().addDocumentListener(new DocumentListener(){

            public void updateTargetDirectory() {
                MobileLocalizationTool.this.targetDirectory = MobileLocalizationTool.this.parseDirectory(targetDirectoryField.getText());
                Preferences p = Preferences.getInstance();
                p.setTargetDirectory(MobileLocalizationTool.this.targetDirectory != null ? MobileLocalizationTool.this.targetDirectory.getAbsolutePath() : "");
                p.save();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateTargetDirectory();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateTargetDirectory();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateTargetDirectory();
            }
        });
        JPanel directoriesPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 0.0;
        directoriesPanel.add((Component)new JLabel("Source XLSX file:"), c);
        c.gridx = 1;
        c.weightx = 1.0;
        directoriesPanel.add((Component)sourceFileField, c);
        c.gridx = 2;
        c.weightx = 0.0;
        directoriesPanel.add((Component)browseSource, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 0.0;
        directoriesPanel.add((Component)new JLabel("Target directory:"), c);
        c.gridx = 1;
        c.weightx = 1.0;
        directoriesPanel.add((Component)targetDirectoryField, c);
        c.gridx = 2;
        c.weightx = 0.0;
        directoriesPanel.add((Component)browseTarget, c);
        JButton goButton = new JButton("Go!");
        goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MobileLocalizationTool.this.go();
            }
        });
        JPanel actionsPanel = new JPanel(new FlowLayout(1, 5, 0));
        actionsPanel.add(goButton);
        JPanel all = new JPanel(new BorderLayout(5, 5));
        all.setBorder(new EmptyBorder(5, 5, 5, 5));
        all.add((Component)directoriesPanel, "North");
        all.add((Component)actionsPanel, "South");
        this.setContentPane(all);
        this.pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frame = this.getSize();
        int x = (screen.width - frame.width) / 2;
        int y = (screen.height - frame.height) / 2;
        this.setLocation(x, y);
        this.setDefaultCloseOperation(3);
        Preferences p = Preferences.getInstance();
        String sourceFile = p.getSourceFile();
        String targetDirectory = p.getTargetDirectory();
        if (sourceFile.length() > 0) {
            sourceFileField.setText(sourceFile);
        }
        if (targetDirectory.length() > 0) {
            targetDirectoryField.setText(targetDirectory);
        }
    }

    private File parseFile(String path) {
        if (path == null) {
            return null;
        }
        if ((path = path.trim()).length() == 0) {
            return null;
        }
        File f = new File(path);
        if (!f.exists()) {
            return null;
        }
        return f;
    }

    private File parseDirectory(String path) {
        File f = this.parseFile(path);
        if (f != null && !f.isDirectory()) {
            return null;
        }
        return f;
    }

    private void go() {
        if (this.sourceFile == null) {
            this.error("Invalid source file path");
            return;
        }
        if (this.targetDirectory == null) {
            this.error("Invalid target directory path");
            return;
        }
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        JPanel all = new JPanel(new BorderLayout(5, 5));
        all.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        all.add((Component)progressBar, "Center");
        final Dialog dialog = new Dialog(this, "Producing...", true);
        dialog.add(all);
        dialog.pack();
        dialog.setResizable(false);
        dialog.setLocationRelativeTo(this);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!dialog.isVisible()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                try {
                    MobileLocalizationTool.this.produceLocalizationFiles(MobileLocalizationTool.this.sourceFile, MobileLocalizationTool.this.targetDirectory);
                    MobileLocalizationTool.this.info("Completed!");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MobileLocalizationTool.this.error("Failed: " + e.getMessage());
                }
                dialog.dispose();
            }
        });
        t.start();
        dialog.setVisible(true);
    }

    private void error(String msg) {
        JOptionPane.showMessageDialog(this, msg, "Error", 0);
    }

    private void info(String msg) {
        JOptionPane.showMessageDialog(this, msg, "Info", 1);
    }

    private void produceLocalizationFiles(File sourceFile, File targetDirectory) throws Exception {
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream inputStream = new FileInputStream(sourceFile);){
            String name;
            Sheet sheet;
            Workbook workbook;
            if (sourceFile.getName().toLowerCase().endsWith(".xlsx")) {
                workbook = new XSSFWorkbook(inputStream);
                sheet = ((XSSFWorkbook)workbook).getSheetAt(0);
            } else {
                workbook = new HSSFWorkbook(inputStream);
                sheet = ((HSSFWorkbook)workbook).getSheetAt(0);
            }
            int iosColumn = -1;
            int androidColumn = -1;
            ArrayList<LanguageColumn> languageColumns = new ArrayList<LanguageColumn>();
            Row header = sheet.getRow(0);
            int i = 0;
            while ((name = this.getCellValue(header, i)) != null) {
                if (name.length() > 0) {
                    if ((name = name.trim().toLowerCase()).equals("ios id")) {
                        iosColumn = i;
                    } else if (name.equals("android id")) {
                        androidColumn = i;
                    } else {
                        String code = LanguageResolver.getInstance().resolveCode(name);
                        if (code == null) {
                            System.err.println("WARNING: language code not found for language: " + name);
                        } else {
                            System.out.println("FOUND LANGUAGE: " + name + " (" + code + ")");
                            LanguageColumn column = new LanguageColumn();
                            column.language = code;
                            column.index = i;
                            languageColumns.add(column);
                        }
                    }
                }
                ++i;
            }
            int size = languageColumns.size();
            int i2 = 0;
            while (i2 < size) {
                LanguageColumn languageColumn = (LanguageColumn)languageColumns.get(i2);
                System.out.println("Exporting language: " + languageColumn.language);
                File iosFile = null;
                if (iosColumn != -1) {
                    iosFile = new File(targetDirectory, "iOS/" + languageColumn.language + ".lproj/Localizable.strings");
                    iosFile.getParentFile().mkdirs();
                }
                File androidFile = null;
                if (androidColumn != -1) {
                    androidFile = new File(targetDirectory, "Android/values-" + languageColumn.language + "/localized_strings.xml");
                    androidFile.getParentFile().mkdirs();
                }
                BufferedWriter iosWriter = null;
                BufferedWriter androidWriter = null;
                try {
                    if (iosColumn != -1) {
                        iosWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(iosFile), "UTF-8"));
                    }
                    if (androidColumn != -1) {
                        androidWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(androidFile), "UTF-8"));
                        androidWriter.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
                        androidWriter.write("<resources>\r\n");
                        androidWriter.flush();
                    }
                    int rowCounter = 1;
                    while (rowCounter <= sheet.getLastRowNum()) {
                        String value;
                        Row row = sheet.getRow(rowCounter);
                        if (row != null && (value = this.getCellValue(row, languageColumn.index)) != null && value.length() > 0) {
                            String id_android;
                            String id_ios;
                            if (iosColumn != -1 && (id_ios = this.getCellValue(row, iosColumn)) != null && id_ios.length() > 0) {
                                String iosValue = value.replaceAll("\r", "").replaceAll("\n", "\\\\n");
                                iosWriter.write("\"" + id_ios.replaceAll("\"", "\\\\\"") + "\" = \"" + iosValue.replaceAll("\"", "\\\\\"") + "\";\r\n");
                                iosWriter.flush();
                            }
                            if (androidColumn != -1 && (id_android = this.getCellValue(row, androidColumn)) != null && id_android.length() > 0) {
                                Pattern p = Pattern.compile("%(\\d+\\$)*([^\\s])");
                                Matcher m = p.matcher(value);
                                String androidValue = "";
                                int index = 0;
                                int counter = 1;
                                while (m.find()) {
                                    androidValue = String.valueOf(androidValue) + value.substring(index, m.start());
                                    androidValue = String.valueOf(androidValue) + "%" + counter++ + "$";
                                    androidValue = "@".equals(m.group(2)) ? String.valueOf(androidValue) + "s" : String.valueOf(androidValue) + m.group(2);
                                    index = m.end();
                                }
                                if (index < value.length()) {
                                    androidValue = String.valueOf(androidValue) + value.substring(index);
                                }
                                androidValue = androidValue.replaceAll("'", "\\\\'").replaceAll("\r", "").replaceAll("\n", "\\n");
                                androidWriter.write("\t<string name=\"" + StringEscapeUtils.escapeXml(id_android) + "\">" + StringEscapeUtils.escapeXml(androidValue) + "</string>\r\n");
                                androidWriter.flush();
                            }
                        }
                        ++rowCounter;
                    }
                    if (androidColumn != -1) {
                        androidWriter.write("</resources>\r\n");
                        androidWriter.flush();
                    }
                }
                finally {
                    if (iosWriter != null) {
                        try {
                            iosWriter.close();
                        }
                        catch (Throwable throwable2) {}
                        System.out.println("iOS file completed: " + iosFile.getAbsolutePath());
                    }
                    if (androidWriter != null) {
                        try {
                            androidWriter.close();
                        }
                        catch (Throwable throwable3) {}
                        System.out.println("Android file completed: " + androidFile.getAbsolutePath());
                    }
                }
                ++i2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private String getCellValue(Row row, int index) {
        String value;
        Cell cell = row.getCell(index);
        if (cell == null) {
            return null;
        }
        if (cell.getCellType() != 1) {
            cell.setCellType(1);
        }
        if ((value = cell.getStringCellValue()) == null) {
            return null;
        }
        return value.trim();
    }

    public static void main(String[] args) {
        MobileLocalizationTool f = new MobileLocalizationTool();
        f.setVisible(true);
    }

    private class BrowseDirectoriesButtonActionListener
    implements ActionListener {
        private JTextField textField;

        public BrowseDirectoriesButtonActionListener(JTextField textField) {
            this.textField = textField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File dir;
            String path = this.textField.getText();
            JFileChooser ch = new JFileChooser(path.length() > 0 ? path : "");
            ch.setFileSelectionMode(1);
            ch.setMultiSelectionEnabled(false);
            int r = ch.showDialog(MobileLocalizationTool.this, "Choose");
            if (r == 0 && (dir = ch.getSelectedFile()) != null) {
                this.textField.setText(dir.getAbsolutePath());
            }
        }
    }

    private class BrowseFilesButtonActionListener
    implements ActionListener {
        private JTextField textField;
        private FileFilter fileFilter;

        public BrowseFilesButtonActionListener(JTextField textField, FileFilter fileFilter) {
            this.textField = textField;
            this.fileFilter = fileFilter;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file;
            String path = this.textField.getText();
            JFileChooser ch = new JFileChooser(path.length() > 0 ? path : "");
            ch.setFileSelectionMode(0);
            ch.setMultiSelectionEnabled(false);
            ch.setFileFilter(this.fileFilter);
            int r = ch.showDialog(MobileLocalizationTool.this, "Choose");
            if (r == 0 && (file = ch.getSelectedFile()) != null) {
                this.textField.setText(file.getAbsolutePath());
            }
        }
    }

    private static class LanguageColumn {
        public String language;
        public int index;

        private LanguageColumn() {
        }
    }
}

