/*
 * Decompiled with CFR 0.152.
 */
package tools.mlocale;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class LanguageResolver {
    private static LanguageResolver instance;
    private Map<String, String> languageCodes = new HashMap<String, String>();

    public static LanguageResolver getInstance() {
        if (instance == null) {
            instance = new LanguageResolver();
        }
        return instance;
    }

    private LanguageResolver() {
        URL resource = this.getClass().getResource("langs.txt");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.openStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    StringTokenizer st1 = new StringTokenizer(line, "\t");
                    StringTokenizer st2 = new StringTokenizer(st1.nextToken(), ";");
                    String code = st1.nextToken().trim().toLowerCase();
                    while (st2.hasMoreTokens()) {
                        String name = st2.nextToken().trim().toLowerCase();
                        this.languageCodes.put(name, code);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String resolveCode(String name) {
        return this.languageCodes.get(name);
    }
}

